/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.imgcontrol;

import com.quantumdata.imgcontrol.ImageControlPage;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Ramp12Page
extends ImageControlPage
implements ChangeListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private JTextField m_startLevel;
    private JSpinner m_spin;
    private JSlider m_slide;

    public Ramp12Page() {
        super("Ramp12");
        JLabel jLabel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel(gridBagLayout);
        this.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        Integer[] integerArray = new Integer[9];
        Font font = new Font("SansSerif", 0, 10);
        for (int i = 0; i <= 8; ++i) {
            int n = i * 512;
            if (n == 4096) {
                --n;
            }
            integerArray[i] = n;
            double d = (double)i / 8.0 * 100.0;
            jLabel = new JLabel(String.format("%1$5.1f%%", d));
            jLabel.setForeground(QDStdUI.getActionForeground());
            jLabel.setFont(font);
            hashtable.put(integerArray[i], jLabel);
        }
        this.m_slide = new JSlider(1, 0, 4095, 0);
        this.m_slide.setPaintLabels(true);
        this.m_slide.setPaintTrack(true);
        this.m_slide.setLabelTable(hashtable);
        this.m_slide.setBackground(QDStdUI.getBackground());
        this.m_slide.addChangeListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.m_slide, gridBagConstraints);
        qDPanel.add(this.m_slide);
        QDPanel qDPanel2 = new QDPanel();
        this.m_startLevel = new JTextField(4);
        this.m_startLevel.addActionListener(this);
        this.m_startLevel.addFocusListener(this);
        jLabel = new QDLabel("Starting Level %: ");
        qDPanel2.add(jLabel);
        qDPanel2.add(this.m_startLevel);
        this.m_spin = new JSpinner();
        this.m_spin.setEditor(this.m_startLevel);
        this.m_spin.addChangeListener(this);
        qDPanel2.add(this.m_spin);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(qDPanel2, gridBagConstraints);
        qDPanel.add(qDPanel2);
        this.add((Component)new JScrollPane(qDPanel), "Center");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_spin) {
            int n = (Integer)this.m_spin.getValue();
            if (n < 0) {
                n = 0;
                this.m_spin.setValue(new Integer(n));
                return;
            }
            if (n > 4095) {
                n = 4095;
                this.m_spin.setValue(new Integer(n));
                return;
            }
            this.setStartLevel(n, true);
        } else if (changeEvent.getSource() == this.m_slide) {
            int n = this.m_slide.getValue();
            this.setStartLevel(n, true);
        }
    }

    protected void readAll() throws InstrumentException {
        this.setStartLevel(Ramp12Page.getInt("XIMG:PARM? " + this.getImageName() + " SLVL"), false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_startLevel) {
            double d = Double.parseDouble(this.m_startLevel.getText());
            int n = (int)Math.round(d / 100.0 * 4095.0);
            if (n < 0) {
                n = 0;
            }
            if (n > 4095) {
                n = 4095;
            }
            this.setStartLevel(n, false);
            this.m_startLevel.selectAll();
        }
    }

    protected void setStartLevel(int n, boolean bl) {
        try {
            String string = Integer.toString(n);
            double d = (double)n / 4095.0 * 100.0;
            this.m_startLevel.setText(String.format("%1$.2f", d));
            this.m_spin.setValue(new Integer(n));
            this.m_slide.setValue(n);
            if (bl) {
                Ramp12Page.sendCmd("XIMG:PARM " + this.getImageName() + " SLVL " + string);
            }
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextField) {
            ((JTextField)focusEvent.getSource()).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

